/*---------------------------------------------------------------------------*\

    FILE....: BRIDGE.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 20/2/02

    Bridges two ports using the firmware bridging feature.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "kbhit.h"

#include "../src/vpbapi.h"
#include "../src/verbose.h"
#include "../src/comm.h"

#ifndef WIN32
extern Comm *vpb_c;   // ptr to comm object
void record_set_hw_gain(int handle, float gain, Comm *c);
#endif 

#define CH              4
#define	BUF_SIZE        160	// size of processing frame (samples) (20ms)
#define DEF_PG          12      // default play gain
#define DEF_RG          -3      // default record gain

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h1,h2,ret,arg,bal;
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	if (argc < 3) {
	       printf("usage: bridge <port1> <type1> <port2> <type1> [--recwav <file1> <file2>] [--hwgain <PlayGain> <RecGain>]\n");
	       printf("\t<portN> = [1..12] \n");
	       printf("\t<typeN> = [s|l] \n");
	       printf("\t<file1/2> is in wav format\n");
	       printf("\t<PlayGain> = [-12..12]\n");
	       printf("\t<RecGain> = [-12..12]\n");
	       exit(0);
	}

	h1 = vpb_open(1,atoi(argv[1]));
	h2 = vpb_open(1,atoi(argv[3]));
	vpb_disable_event(h1, VPB_MTONEDETECT);
	vpb_disable_event(h2, VPB_MTONEDETECT);

	if (!strcmp(argv[2],"l"))
		vpb_sethook_sync(h1,VPB_OFFHOOK);
	if (!strcmp(argv[4],"l"))
		vpb_sethook_sync(h2,VPB_OFFHOOK);
	else {
		// special mod for Simple Simon OpenLine4 hardware
		// which were specially modifed V16 OpenLine4's (V4PCIs)
		// only for "./bridge [1-3] l 4 s" case

		vpb_get_model(s);
		if (strcmp(s,"VPB4") == 0) {
			// audio sw but not loop
			vpb_set_codec_reg(h2, 0x12, 0x7c);
			vpb_set_codec_reg(h2, 0x0a, 0x20); 
		}
		
	}		
       
	if ((arg = arg_exists(argc, argv, "--bal1")) != 0) {
	  bal = strtol(argv[arg+1], NULL, 16);
	  assert((bal >= 0) && (bal <= 255));
	  assert((bal >= 0) && (bal <= 255));
	  vpb_set_codec_reg(h1, 0x32, bal);
	  vpb_set_codec_reg(h2, 0x32, bal);
	}
 
	if ((arg = arg_exists(argc, argv, "--recwav"))) {	  
		vpb_record_file_async(h1, argv[arg+1], VPB_LINEAR);
		vpb_record_file_async(h2, argv[arg+1], VPB_LINEAR);
		printf("Started recording: %s\n", argv[arg+1]);
	}

	// set up play and record gain plan

	float rg = DEF_RG;
	float pg = DEF_PG;

	if ((arg = arg_exists(argc, argv, "--hwgain"))) {	  
		pg = (float)atof(argv[arg+1]);
		rg = (float)atof(argv[arg+2]);
		printf("play gain   = %f\n", pg);
		printf("record gain = %f\n", rg);
	}
	vpb_record_set_hw_gain(h1, rg); 
	vpb_play_set_hw_gain  (h1, pg); 
	vpb_record_set_hw_gain(h2, rg); 
	vpb_play_set_hw_gain  (h2, pg); 

	vpb_bridge(h1, h2, VPB_BRIDGE_ON, 1);

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}

		vpb_sleep(20);

	} while(!kbhit());

	if ((arg = arg_exists(argc, argv, "--recwav"))) {	  
		vpb_record_terminate(h1);
		printf("Stopped recording: %s\n", argv[arg+1]);
	}

	vpb_bridge(h1, h2, VPB_BRIDGE_OFF, 1);
	if (!strcmp(argv[2],"l"))
		vpb_sethook_sync(h1,VPB_ONHOOK);
	if (!strcmp(argv[4],"l"))
		vpb_sethook_sync(h2,VPB_ONHOOK);
	vpb_close(h1);
	vpb_close(h2);

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








